using System;
using System.Collections;
using Server.Multis;
using Server.Mobiles;
using Server.Network;

namespace Server.Items
{
	public class BonePile : BaseContainer
	{
		public override int DefaultGumpID{ get{ return 9; } }
		public override int DefaultDropSound{ get{ return 66; } }

		public override Rectangle2D Bounds
		{
			get{ return new Rectangle2D( 20, 85, 104, 111 ); }
		}

		[Constructable]
		public BonePile() : base( 3786 )
		{
			Weight = 10.0;
			ItemID = Utility.RandomMinMax( 3786, 3794 );
		}

		public BonePile( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}